import iesve
from ies_file_picker import IesFilePicker

file_name = IesFilePicker.pick_aps_file()
f = iesve.ResultsReader()
f.open_aps_data(file_name)


def max_loads(results):
    BE = results.get_results('Boilers energy', 'Boilers energy', 'e')
    CE = results.get_results('Chillers energy', 'Chillers energy', 'e')
    BL = results.get_results('Boilers load', 'Boilers load', 'l')
    CL = results.get_results('Chillers load', 'Chillers load', 'l')
    print("max Boilers energy",round(max(BE)/1000,0),"kW")
    print("max Chillers energy",round(max(CE)/1000,0),"kW")
    print("max Boilers load",round(max(BL)/1000,0),"kW")
    print("max Chillers load",round(max(CL)/1000,0),"kW")
    
    return(max(BL))
    
max_BL = max_loads(f)


project = iesve.VEProject.get_current_project()
real_building = project.models[0]
bodies = real_building.get_bodies(False)

def room_temp(results):
    room_temp=[]
    for body in bodies:
        temp = results.get_room_results(body.id,'Room air temperature', 'Air temperature', 'z')        
        print("Max air temp in {} ({}) is {} degrees celsius".format(body.name, body.id, round(max(temp)),0))
        room_temp.append(max(temp))
        
    return(max(room_temp))

max_temp = room_temp(f)